# Rising Chat

Sesli sohbet, ekran paylaşımı ve metin chat'i olan iletişim platformu.

## Özellikler
- Kayıt / Giriş (JWT)
- Sunucu oluşturma & davet sistemi
- Metin kanalları (gerçek zamanlı)
- Sesli kanallar (WebRTC)
- Ekran paylaşımı
- Direkt mesaj
- Arkadaş sistemi

## Geliştirme

### Gereksinimler
- Node.js 20+
- MySQL veritabanı

### Kurulum

```bash
# Kök dizinde
npm install

# .env oluştur
cp server/.env.example server/.env
# DATABASE_URL düzenle

# Veritabanı migrate
cd server && npx prisma migrate dev --name init && cd ..

# Çalıştır
npm run dev
```

Frontend: http://localhost:5173
Backend: http://localhost:3001

## Production Deploy

### Backend → Railway
1. GitHub'a push yap
2. railway.app → New Project → GitHub repo
3. MySQL plugin ekle
4. Environment variables:
   - `DATABASE_URL` (Railway MySQL URL)
   - `JWT_SECRET`
   - `JWT_REFRESH_SECRET`
   - `CLIENT_URL` (cPanel site URL)

### Frontend → cPanel
```bash
cd client
VITE_API_URL=https://your-app.railway.app npm run build
# dist/ klasörünü cPanel public_html'e yükle
```

> `.htaccess` dosyası eklemeyi unutma (React Router için):
```
Options -MultiViews
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteRule ^ index.html [QSA,L]
```
