import api from './axios.ts';

export const friendApi = {
  list: () => api.get('/friends'),
  pending: () => api.get('/friends/pending'),
  send: (username: string, discriminator: string) => api.post('/friends', { username, discriminator }),
  accept: (id: string) => api.post(`/friends/${id}/accept`),
  decline: (id: string) => api.post(`/friends/${id}/decline`),
  remove: (id: string) => api.delete(`/friends/${id}`),
};
