import api from './axios.ts';

export const serverApi = {
  list: () => api.get('/servers'),
  create: (name: string) => api.post('/servers', { name }),
  get: (id: string) => api.get(`/servers/${id}`),
  delete: (id: string) => api.delete(`/servers/${id}`),
  leave: (id: string) => api.post(`/servers/${id}/leave`),
  preview: (code: string) => api.get(`/servers/invite/${code}`),
  join: (code: string) => api.post(`/servers/invite/${code}/join`),
  regenerateInvite: (id: string) => api.post(`/servers/${id}/invite/regenerate`),
  updateRole: (serverId: string, userId: string, role: string) =>
    api.patch(`/servers/${serverId}/members/${userId}/role`, { role }),
  kick: (serverId: string, userId: string) =>
    api.delete(`/servers/${serverId}/members/${userId}`),
};
