import { useEffect } from 'react';
import { Outlet, useNavigate, useLocation } from 'react-router-dom';
import { useAuthStore } from '../../stores/authStore.ts';
import { useServerStore } from '../../stores/serverStore.ts';
import { connectSocket, disconnectSocket } from '../../socket/socket.ts';
import { serverApi } from '../../api/server.api.ts';
import ServerSidebar from './ServerSidebar.tsx';
import ChannelSidebar from './ChannelSidebar.tsx';
import VoiceRoom from '../voice/VoiceRoom.tsx';

export default function AppLayout() {
  const { user, accessToken, logout } = useAuthStore();
  const { setServers, activeServerId } = useServerStore();
  const navigate = useNavigate();
  const location = useLocation();

  // Show ChannelSidebar if we're on a server route (even before store updates)
  const isServerRoute = /^\/servers\//.test(location.pathname);
  const showChannelSidebar = !!(activeServerId || isServerRoute);

  useEffect(() => {
    if (!accessToken) return;
    connectSocket(accessToken);
    return () => { disconnectSocket(); };
  }, [accessToken]);

  useEffect(() => {
    serverApi.list().then((r) => setServers(r.data)).catch(() => {});
  }, []);

  const handleLogout = async () => {
    logout();
    navigate('/login');
  };

  return (
    <div style={{ display: 'flex', height: '100vh', overflow: 'hidden' }}>
      <ServerSidebar />
      {showChannelSidebar && <ChannelSidebar />}
      <main style={{
        flex: 1,
        display: 'flex',
        flexDirection: 'column',
        background: 'var(--bg-primary)',
        overflow: 'hidden',
      }}>
        <Outlet />
      </main>
      <VoiceRoom />
    </div>
  );
}
