import { useState, useRef } from 'react';

interface Props {
  placeholder?: string;
  onSend: (content: string) => void;
  onTyping?: () => void;
}

export default function MessageInput({ placeholder = 'Bir mesaj yazın...', onSend, onTyping }: Props) {
  const [value, setValue] = useState('');
  const typingRef = useRef<ReturnType<typeof setTimeout> | null>(null);

  const handleSend = () => {
    if (!value.trim()) return;
    onSend(value.trim());
    setValue('');
  };

  const handleChange = (v: string) => {
    setValue(v);
    onTyping?.();
    if (typingRef.current) clearTimeout(typingRef.current);
  };

  return (
    <div style={{
      padding: '12px 16px',
      borderTop: '1px solid var(--border)',
      display: 'flex', gap: 10, alignItems: 'flex-end',
      background: 'var(--bg-card)',
    }}>
      <div style={{ flex: 1, background: 'var(--bg-card2)', borderRadius: 10, border: '1px solid var(--border)', padding: '10px 14px' }}>
        <textarea
          value={value}
          onChange={(e) => handleChange(e.target.value)}
          onKeyDown={(e) => { if (e.key === 'Enter' && !e.shiftKey) { e.preventDefault(); handleSend(); } }}
          placeholder={placeholder}
          rows={1}
          style={{
            width: '100%', background: 'transparent', border: 'none', outline: 'none',
            color: 'var(--text-primary)', fontFamily: 'Outfit, sans-serif', fontSize: 14,
            resize: 'none', lineHeight: 1.5, maxHeight: 120, overflowY: 'auto',
          }}
          onInput={(e) => {
            const t = e.currentTarget;
            t.style.height = 'auto';
            t.style.height = Math.min(t.scrollHeight, 120) + 'px';
          }}
        />
      </div>
      <button className="btn-primary" onClick={handleSend} disabled={!value.trim()}
        style={{ width: 40, height: 40, borderRadius: '50%', display: 'flex', alignItems: 'center', justifyContent: 'center', padding: 0, flexShrink: 0 }}>
        <i className="fas fa-paper-plane" />
      </button>
    </div>
  );
}
