interface AvatarProps {
  src?: string;
  username: string;
  size?: number;
  status?: string;
}

export default function Avatar({ src, username, size = 36, status }: AvatarProps) {
  const initials = username.slice(0, 2).toUpperCase();
  return (
    <div style={{ position: 'relative', width: size, height: size, flexShrink: 0 }}>
      {src ? (
        <img src={src} alt={username} style={{ width: size, height: size, borderRadius: '50%', objectFit: 'cover' }} />
      ) : (
        <div style={{
          width: size, height: size, borderRadius: '50%',
          background: 'linear-gradient(135deg, #8b5cf6, #06b6d4)',
          display: 'flex', alignItems: 'center', justifyContent: 'center',
          color: 'white', fontSize: size * 0.35, fontWeight: 700,
        }}>
          {initials}
        </div>
      )}
      {status && (
        <div className={`status-dot ${status}`} style={{
          position: 'absolute', bottom: 0, right: 0,
          width: size * 0.28, height: size * 0.28,
          border: `2px solid var(--bg-card)`,
        }} />
      )}
    </div>
  );
}
