import { io, type Socket } from 'socket.io-client';
import type { ServerToClientEvents, ClientToServerEvents } from '@rc/shared';

export const socket: Socket<ServerToClientEvents, ClientToServerEvents> = io({ autoConnect: false, withCredentials: true });

export function connectSocket(token: string) {
  socket.auth = { token };
  socket.connect();
}

export function disconnectSocket() {
  socket.disconnect();
}
