import { create } from 'zustand';
import type { FriendRequest, User } from '@rc/shared';

interface FriendState {
  friends: User[];
  pendingRequests: FriendRequest[];
  setFriends: (friends: User[]) => void;
  setPendingRequests: (reqs: FriendRequest[]) => void;
  addRequest: (req: FriendRequest) => void;
  removeRequest: (id: string) => void;
}

export const useFriendStore = create<FriendState>((set) => ({
  friends: [],
  pendingRequests: [],
  setFriends: (friends) => set({ friends }),
  setPendingRequests: (pendingRequests) => set({ pendingRequests }),
  addRequest: (req) => set((s) => ({ pendingRequests: [...s.pendingRequests, req] })),
  removeRequest: (id) => set((s) => ({ pendingRequests: s.pendingRequests.filter((r) => r.id !== id) })),
}));
