import { create } from 'zustand';
import type { Message } from '@rc/shared';

interface MessageState {
  messages: Record<string, Message[]>;
  setMessages: (channelId: string, msgs: Message[]) => void;
  addMessage: (channelId: string, msg: Message) => void;
  updateMessage: (channelId: string, msg: Message) => void;
  removeMessage: (channelId: string, messageId: string) => void;
}

export const useMessageStore = create<MessageState>((set) => ({
  messages: {},
  setMessages: (channelId, msgs) => set((s) => ({ messages: { ...s.messages, [channelId]: msgs } })),
  addMessage: (channelId, msg) => set((s) => ({
    messages: { ...s.messages, [channelId]: [...(s.messages[channelId] || []), msg] },
  })),
  updateMessage: (channelId, msg) => set((s) => ({
    messages: { ...s.messages, [channelId]: (s.messages[channelId] || []).map((m) => m.id === msg.id ? msg : m) },
  })),
  removeMessage: (channelId, messageId) => set((s) => ({
    messages: { ...s.messages, [channelId]: (s.messages[channelId] || []).filter((m) => m.id !== messageId) },
  })),
}));
