import { BrowserRouter, Routes, Route, Navigate } from 'react-router-dom';
import { useAuthStore } from './stores/authStore.ts';
import LoginPage from './pages/LoginPage.tsx';
import RegisterPage from './pages/RegisterPage.tsx';
import AppLayout from './components/layout/AppLayout.tsx';
import FriendsPage from './pages/FriendsPage.tsx';
import DMPage from './pages/DMPage.tsx';
import ChannelPage from './pages/ChannelPage.tsx';
import InvitePage from './pages/InvitePage.tsx';

function PrivateRoute({ children }: { children: React.ReactNode }) {
  const user = useAuthStore((s) => s.user);
  return user ? <>{children}</> : <Navigate to="/login" replace />;
}

function PublicRoute({ children }: { children: React.ReactNode }) {
  const user = useAuthStore((s) => s.user);
  return user ? <Navigate to="/" replace /> : <>{children}</>;
}

export default function App() {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/login" element={<PublicRoute><LoginPage /></PublicRoute>} />
        <Route path="/register" element={<PublicRoute><RegisterPage /></PublicRoute>} />
        <Route path="/invite/:code" element={<InvitePage />} />
        <Route path="/" element={<PrivateRoute><AppLayout /></PrivateRoute>}>
          <Route index element={<FriendsPage />} />
          <Route path="dm/:userId" element={<DMPage />} />
          <Route path="servers/:serverId/channels/:channelId" element={<ChannelPage />} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
}
