import api from './axios.ts';

export const dmApi = {
  conversations: () => api.get('/dm/conversations'),
  messages: (userId: string, before?: string) => api.get(`/dm/${userId}`, { params: { before } }),
  send: (userId: string, content: string) => api.post(`/dm/${userId}`, { content }),
  edit: (id: string, content: string) => api.patch(`/dm/${id}`, { content }),
  delete: (id: string) => api.delete(`/dm/${id}`),
};
