import api from './axios.ts';

export const messageApi = {
  list: (serverId: string, channelId: string, before?: string) =>
    api.get(`/servers/${serverId}/channels/${channelId}/messages`, { params: { before } }),
  send: (serverId: string, channelId: string, content: string) =>
    api.post(`/servers/${serverId}/channels/${channelId}/messages`, { content }),
  edit: (serverId: string, channelId: string, id: string, content: string) =>
    api.patch(`/servers/${serverId}/channels/${channelId}/messages/${id}`, { content }),
  delete: (serverId: string, channelId: string, id: string) =>
    api.delete(`/servers/${serverId}/channels/${channelId}/messages/${id}`),
};
