import { create } from 'zustand';
import type { Server, Channel } from '@rc/shared';

interface ServerState {
  servers: Server[];
  activeServerId: string | null;
  activeChannelId: string | null;
  setServers: (servers: Server[]) => void;
  addServer: (server: Server) => void;
  removeServer: (id: string) => void;
  updateServer: (server: Server) => void;
  setActiveServer: (id: string | null) => void;
  setActiveChannel: (id: string | null) => void;
  activeServer: () => Server | undefined;
  activeChannel: () => Channel | undefined;
}

export const useServerStore = create<ServerState>((set, get) => ({
  servers: [],
  activeServerId: null,
  activeChannelId: null,
  setServers: (servers) => set({ servers }),
  addServer: (server) => set((s) => ({ servers: [...s.servers, server] })),
  removeServer: (id) => set((s) => ({ servers: s.servers.filter((sv) => sv.id !== id) })),
  updateServer: (server) => set((s) => ({ servers: s.servers.map((sv) => sv.id === server.id ? server : sv) })),
  setActiveServer: (id) => set({ activeServerId: id }),
  setActiveChannel: (id) => set({ activeChannelId: id }),
  activeServer: () => get().servers.find((s) => s.id === get().activeServerId),
  activeChannel: () => {
    const server = get().activeServer();
    return server?.channels.find((c) => c.id === get().activeChannelId);
  },
}));
