import express from 'express';
import cors from 'cors';
import cookieParser from 'cookie-parser';
import { corsOptions } from './config/cors.js';
import { errorHandler } from './middleware/errorHandler.js';
import { requireAuth } from './middleware/auth.js';
import authRoutes from './routes/auth.routes.js';
import serverRoutes from './routes/server.routes.js';
import dmRoutes from './routes/dm.routes.js';
import friendRoutes from './routes/friend.routes.js';
import notificationRoutes from './routes/notification.routes.js';

const app = express();

app.use(cors(corsOptions));
app.use(express.json());
app.use(cookieParser());

app.use('/api/auth', authRoutes);
app.use('/api/servers', requireAuth, serverRoutes);
app.use('/api/dm', requireAuth, dmRoutes);
app.use('/api/friends', requireAuth, friendRoutes);
app.use('/api/notifications', requireAuth, notificationRoutes);

app.use(errorHandler);

export default app;
