import type { Request, Response, NextFunction } from 'express';
import * as svc from '../services/channel.service.js';

export async function create(req: Request, res: Response, next: NextFunction) {
  try { res.status(201).json(await svc.createChannel(req.params.serverId, req.body.name, req.body.type, req.body.topic)); } catch (e) { next(e); }
}
export async function list(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getChannels(req.params.serverId)); } catch (e) { next(e); }
}
export async function get(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getChannel(req.params.id)); } catch (e) { next(e); }
}
export async function update(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.updateChannel(req.params.id, req.body)); } catch (e) { next(e); }
}
export async function remove(req: Request, res: Response, next: NextFunction) {
  try { await svc.deleteChannel(req.params.id); res.json({ message: 'Channel deleted' }); } catch (e) { next(e); }
}
