import type { Request, Response, NextFunction } from 'express';
import * as svc from '../services/friend.service.js';

export async function sendRequest(req: Request, res: Response, next: NextFunction) {
  try { res.status(201).json(await svc.sendRequest(req.userId, req.body.username, req.body.discriminator)); } catch (e) { next(e); }
}
export async function accept(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.acceptRequest(req.params.id, req.userId)); } catch (e) { next(e); }
}
export async function decline(req: Request, res: Response, next: NextFunction) {
  try { await svc.declineRequest(req.params.id, req.userId); res.json({ message: 'Request declined' }); } catch (e) { next(e); }
}
export async function list(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getFriends(req.userId)); } catch (e) { next(e); }
}
export async function pending(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getPendingRequests(req.userId)); } catch (e) { next(e); }
}
export async function remove(req: Request, res: Response, next: NextFunction) {
  try { await svc.removeFriend(req.userId, req.params.id); res.json({ message: 'Friend removed' }); } catch (e) { next(e); }
}
