import type { Request, Response, NextFunction } from 'express';
import * as svc from '../services/message.service.js';

export async function list(req: Request, res: Response, next: NextFunction) {
  try {
    const { limit, before } = req.query;
    res.json(await svc.getMessages(req.params.channelId, limit ? parseInt(limit as string) : 50, before as string));
  } catch (e) { next(e); }
}
export async function create(req: Request, res: Response, next: NextFunction) {
  try { res.status(201).json(await svc.createMessage(req.params.channelId, req.userId, req.body.content)); } catch (e) { next(e); }
}
export async function edit(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.editMessage(req.params.id, req.userId, req.body.content)); } catch (e) { next(e); }
}
export async function remove(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.deleteMessage(req.params.id, req.userId)); } catch (e) { next(e); }
}
