import type { Request, Response, NextFunction } from 'express';
import * as svc from '../services/server.service.js';

export async function create(req: Request, res: Response, next: NextFunction) {
  try { res.status(201).json(await svc.createServer(req.body.name, req.userId, req.body.iconUrl)); } catch (e) { next(e); }
}
export async function get(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getServer(req.params.id)); } catch (e) { next(e); }
}
export async function list(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getUserServers(req.userId)); } catch (e) { next(e); }
}
export async function join(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.joinServerByInvite(req.params.code, req.userId)); } catch (e) { next(e); }
}
export async function preview(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getServerPreview(req.params.code)); } catch (e) { next(e); }
}
export async function leave(req: Request, res: Response, next: NextFunction) {
  try { await svc.leaveServer(req.params.id, req.userId); res.json({ message: 'Left server' }); } catch (e) { next(e); }
}
export async function remove(req: Request, res: Response, next: NextFunction) {
  try { await svc.deleteServer(req.params.id, req.userId); res.json({ message: 'Server deleted' }); } catch (e) { next(e); }
}
export async function updateRole(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.updateMemberRole(req.params.id, req.params.userId, req.body.role, req.userId)); } catch (e) { next(e); }
}
export async function kick(req: Request, res: Response, next: NextFunction) {
  try { await svc.kickMember(req.params.id, req.params.userId, req.userId); res.json({ message: 'Member kicked' }); } catch (e) { next(e); }
}
export async function regenerateInvite(req: Request, res: Response, next: NextFunction) {
  try { res.json({ inviteCode: await svc.regenerateInvite(req.params.id) }); } catch (e) { next(e); }
}
