import { Router } from 'express';
import * as ctrl from '../controllers/server.controller.js';
import channelRoutes from './channel.routes.js';
import messageRoutes from './message.routes.js';

const router = Router();
router.get('/', ctrl.list);
router.post('/', ctrl.create);
router.get('/invite/:code', ctrl.preview);
router.post('/invite/:code/join', ctrl.join);
router.get('/:id', ctrl.get);
router.delete('/:id', ctrl.remove);
router.post('/:id/leave', ctrl.leave);
router.post('/:id/invite/regenerate', ctrl.regenerateInvite);
router.patch('/:id/members/:userId/role', ctrl.updateRole);
router.delete('/:id/members/:userId', ctrl.kick);
router.use('/:serverId/channels', channelRoutes);
router.use('/:serverId/channels/:channelId/messages', messageRoutes);
export default router;
