import { prisma } from '../config/prisma.js';

export async function createNotification(recipientId: string, type: string, title: string, body: string, relatedId?: string) {
  return prisma.notification.create({ data: { userId: parseInt(recipientId), type, title, body, relatedId } });
}

export async function getNotifications(userId: string, unreadOnly = false, limit = 20) {
  return prisma.notification.findMany({
    where: { userId: parseInt(userId), ...(unreadOnly && { read: false }) },
    orderBy: { createdAt: 'desc' },
    take: limit,
  });
}

export async function markAsRead(notificationId: string, userId: string) {
  return prisma.notification.updateMany({ where: { id: parseInt(notificationId), userId: parseInt(userId) }, data: { read: true } });
}

export async function markAllAsRead(userId: string) {
  await prisma.notification.updateMany({ where: { userId: parseInt(userId), read: false }, data: { read: true } });
}
