import type { Socket } from 'socket.io';
import jwt from 'jsonwebtoken';
import { env } from '../config/env.js';

export function authenticateSocket(socket: Socket, next: (err?: Error) => void) {
  const token = socket.handshake.auth.token as string;
  if (!token) return next(new Error('Authentication required'));
  try {
    const decoded = jwt.verify(token, env.JWT_SECRET) as { userId: string };
    socket.data.user = { userId: decoded.userId };
    next();
  } catch {
    next(new Error('Invalid token'));
  }
}
