import type { Server, Socket } from 'socket.io';

export function chatHandler(_io: Server, socket: Socket) {
  socket.on('typing:start', (channelId: string) => {
    socket.to(`channel:${channelId}`).emit('typing:start', {
      channelId,
      userId: socket.data.user.userId,
      username: socket.data.user.username || '',
    });
  });

  socket.on('typing:stop', (channelId: string) => {
    socket.to(`channel:${channelId}`).emit('typing:stop', {
      channelId,
      userId: socket.data.user.userId,
    });
  });
}
