import type { Server, Socket } from 'socket.io';
import { prisma } from '../config/prisma.js';

export function presenceHandler(io: Server, socket: Socket) {
  const userId = socket.data.user.userId;
  socket.join(`user:${userId}`);

  prisma.user.update({ where: { id: parseInt(userId) }, data: { status: 'online' } }).then(() => {
    io.emit('presence:update', { userId, status: 'online' });
  }).catch(() => {});

  socket.on('presence:set', async (status: string) => {
    await prisma.user.update({ where: { id: parseInt(userId) }, data: { status: status as any } });
    io.emit('presence:update', { userId, status });
  });

  socket.on('disconnect', async () => {
    await prisma.user.update({ where: { id: parseInt(userId) }, data: { status: 'offline' } }).catch(() => {});
    io.emit('presence:update', { userId, status: 'offline' });
  });
}
