export type UserStatus = 'online' | 'idle' | 'dnd' | 'offline';
export type MemberRole = 'admin' | 'moderator' | 'member';
export type ChannelType = 'text' | 'voice';
export type FriendStatus = 'pending' | 'accepted' | 'declined';
export type NotificationType = 'friend_request' | 'friend_accepted' | 'server_invite' | 'mention';

export interface User {
  _id: string;
  username: string;
  discriminator: string;
  email: string;
  avatarUrl: string;
  status: UserStatus;
  customStatus?: string | null;
}

export interface ServerMember {
  id: string;
  userId: string;
  serverId: string;
  role: MemberRole;
  joinedAt: string;
  user: Pick<User, '_id' | 'username' | 'discriminator' | 'avatarUrl' | 'status'>;
}

export interface Channel {
  id: string;
  name: string;
  type: ChannelType;
  topic?: string | null;
  position: number;
  serverId: string;
}

export interface Server {
  id: string;
  name: string;
  iconUrl?: string | null;
  inviteCode: string;
  ownerId: string;
  members: ServerMember[];
  channels: Channel[];
}

export interface Message {
  id: string;
  content: string;
  edited: boolean;
  editedAt?: string | null;
  channelId: string;
  userId: string;
  createdAt: string;
  user: Pick<User, '_id' | 'username' | 'discriminator' | 'avatarUrl' | 'status'>;
}

export interface DirectMessage {
  id: string;
  content: string;
  read: boolean;
  senderId: string;
  receiverId: string;
  createdAt: string;
  sender: Pick<User, '_id' | 'username' | 'discriminator' | 'avatarUrl' | 'status'>;
  receiver: Pick<User, '_id' | 'username' | 'discriminator' | 'avatarUrl' | 'status'>;
}

export interface FriendRequest {
  id: string;
  senderId: string;
  receiverId: string;
  status: FriendStatus;
  createdAt: string;
  sender: Pick<User, '_id' | 'username' | 'discriminator' | 'avatarUrl' | 'status'>;
  receiver: Pick<User, '_id' | 'username' | 'discriminator' | 'avatarUrl' | 'status'>;
}

export interface Notification {
  id: string;
  userId: string;
  type: NotificationType;
  title: string;
  body: string;
  relatedId?: string | null;
  read: boolean;
  createdAt: string;
}
