import type { Request, Response, NextFunction } from 'express';
import * as svc from '../services/dm.service.js';

export async function conversations(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getConversations(req.userId)); } catch (e) { next(e); }
}
export async function messages(req: Request, res: Response, next: NextFunction) {
  try {
    const { limit, before } = req.query;
    res.json(await svc.getMessages(req.userId, req.params.userId, limit ? parseInt(limit as string) : 50, before as string));
  } catch (e) { next(e); }
}
export async function send(req: Request, res: Response, next: NextFunction) {
  try { res.status(201).json(await svc.sendMessage(req.userId, req.params.userId, req.body.content)); } catch (e) { next(e); }
}
export async function edit(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.editMessage(req.params.id, req.userId, req.body.content)); } catch (e) { next(e); }
}
export async function remove(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.deleteMessage(req.params.id, req.userId)); } catch (e) { next(e); }
}
