import type { Request, Response, NextFunction } from 'express';
import * as svc from '../services/notification.service.js';

export async function list(req: Request, res: Response, next: NextFunction) {
  try { res.json(await svc.getNotifications(req.userId, req.query.unread === 'true')); } catch (e) { next(e); }
}
export async function markRead(req: Request, res: Response, next: NextFunction) {
  try { await svc.markAsRead(req.params.id, req.userId); res.json({ message: 'Marked as read' }); } catch (e) { next(e); }
}
export async function markAllRead(req: Request, res: Response, next: NextFunction) {
  try { await svc.markAllAsRead(req.userId); res.json({ message: 'All marked as read' }); } catch (e) { next(e); }
}
