import http from 'http';
import { Server as SocketServer } from 'socket.io';
import app from './app.js';
import { prisma } from './config/prisma.js';
import { env } from './config/env.js';
import { initSocket } from './socket/index.js';
import type { ServerToClientEvents, ClientToServerEvents } from '@rc/shared';

const server = http.createServer(app);

const io = new SocketServer<ClientToServerEvents, ServerToClientEvents>(server, {
  cors: { origin: env.CLIENT_URL, credentials: true },
});

app.set('io', io);
initSocket(io);

async function start() {
  await prisma.$connect();
  console.log('MySQL connected');
  server.listen(env.PORT, () => console.log(`Server running on http://localhost:${env.PORT}`));
}

start();
