import type { Server } from 'socket.io';
import { authenticateSocket } from './authSocket.js';
import { presenceHandler } from './presenceHandler.js';
import { chatHandler } from './chatHandler.js';
import { voiceHandler } from './voiceHandler.js';
import type { ServerToClientEvents, ClientToServerEvents } from '@rc/shared';

export function initSocket(io: Server<ClientToServerEvents, ServerToClientEvents>) {
  io.use(authenticateSocket);

  io.on('connection', (socket) => {
    presenceHandler(io, socket);
    chatHandler(io, socket);
    voiceHandler(io, socket);
  });
}
