import type { Message, DirectMessage, User, FriendRequest } from './models.js';

export interface ServerToClientEvents {
  'message:new': (msg: Message) => void;
  'message:edited': (msg: Message) => void;
  'message:deleted': (data: { messageId: string; channelId: string }) => void;
  'dm:new': (msg: DirectMessage) => void;
  'dm:edited': (msg: DirectMessage) => void;
  'dm:deleted': (data: { messageId: string }) => void;
  'presence:update': (data: { userId: string; status: User['status'] }) => void;
  'friend:request': (req: FriendRequest) => void;
  'friend:accepted': (req: FriendRequest) => void;
  'voice:participants': (data: { channelId: string; users: string[] }) => void;
  'voice:user-joined': (data: { userId: string; username: string; channelId: string }) => void;
  'voice:user-left': (data: { userId: string; channelId: string }) => void;
  'voice:signal': (data: { from: string; signal: unknown }) => void;
  'typing:start': (data: { channelId: string; userId: string; username: string }) => void;
  'typing:stop': (data: { channelId: string; userId: string }) => void;
}

export interface ClientToServerEvents {
  'voice:join': (channelId: string) => void;
  'voice:leave': (channelId: string) => void;
  'voice:signal': (data: { to: string; signal: unknown }) => void;
  'typing:start': (channelId: string) => void;
  'typing:stop': (channelId: string) => void;
  'presence:set': (status: User['status']) => void;
}
